package ru.yandex.webmaster3.core.turbo.model.advertising;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * Тип рекламной сети
 * Created by Oleg Bazdyrev on 05/07/2017.
 */
@Getter
@RequiredArgsConstructor
public enum AdvertisingNetworkType {

    YANDEX(AdvertisingDisplayType.ID, 1, "Yandex", ""),
    ADFOX(AdvertisingDisplayType.CODE, 1, "AdFox", "adfox"),
    ADFOX_INPAGE(AdvertisingDisplayType.CODE, 1, "AdFoxInPage", "inpage_adfox"),
    ADFOX_INTERSCROLLER(AdvertisingDisplayType.CODE, 1, "AdFoxInterScroller", "interscroller_adfox"),
    @Deprecated(forRemoval = true)
    YANDEX_INPAGE(AdvertisingDisplayType.ID, 1, "YandexInPage", ""),
    ADFOX_INSTREAM(AdvertisingDisplayType.CODE, 1, "AdFoxInStream", "instream_adfox"),
    YANDEX_INSTREAM(AdvertisingDisplayType.ID, 1, "videohosting", ""),
    YANDEX_REC_WIDGET(AdvertisingDisplayType.ID,1,"rec_widget","");
    ;

    private final AdvertisingDisplayType displayType; // что отображать фронту для value
    private final int maxCount;
    private final String displayName;
    private final String adType;

    @JsonIgnore
    public boolean isInstream() {
        return this == ADFOX_INSTREAM || this == YANDEX_INSTREAM;
    }
}
