package ru.yandex.webmaster3.core.turbo.model.advertising;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * Created by Oleg Bazdyrev on 15/01/2019.
 */
public enum AdvertisingPlacement {

    @Description("баннер над шапкой")
    TOP(1, "top"),
    @Description("баннер под шапкой (это под меню перед основным контентом)?")
    HORIZONTAL(0, "horizontal"),
    @Description("баннер внутри статьи")
    CONTENT(0, "auto"),
    @Description("баннер в левой колонке")
    ASIDE_LEFT(0, "aside-left"),
    @Description("баннер в правой колонке")
    ASIDE_RIGHT(0, "aside-right"),
    @Description("ручное размещение")
    MANUAL(0, "manual"),
    @Description("ручное размещение")
    MANUAL_TOP(1, "manual_top"),
    @Description("Залипающий блок снизу")
    STICKY(0, "auto"),
    @Description("ручное размещение")
    MANUAL_STICKY(1, "manual"),
    @Description("InStream-реклама")
    COMMON(0, "common"),
    @Description("Рекламный блок на фоне сайта")
    BACKGROUND(1, "background"),
    @Description("Автоматическая реклама в бесконечной ленте")
    TAPE(1, "auto_cards"),
    @Description("Ручная реклама в бесконечной ленте")
    MANUAL_TAPE(1, "manual_cards"),
    @Description("Рекомендательный виджет")
    REC_WIDGET(1, "auto")
    ;

    private final int maxCount;
    private final String displayName;

    AdvertisingPlacement(int maxCount, String displayName) {
        this.maxCount = maxCount;
        this.displayName = displayName;
    }

    public int getMaxCount() {
        return maxCount;
    }

    public String getDisplayName() {
        return displayName;
    }
}
