package ru.yandex.webmaster3.core.turbo.model.advertising;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;

import ru.yandex.webmaster3.core.util.json.JsonMapping;

/**
 * Created by Oleg Bazdyrev on 15/02/2019.
 * TODO безумный костыль, надо выпилить в будущем
 * Нужен только как временное решение для десериализации TurboHostSettings
 */
public class AdvertisingSettingsMapDeserializer extends StdDeserializer<Map<AdvertisingPlacement, List<AdvertisingSettings>>> {

    private TypeReference<Map<AdvertisingPlacement, List<AdvertisingSettings>>> MAP_REFERENCE =
            new TypeReference<Map<AdvertisingPlacement, List<AdvertisingSettings>>>() {
    };
    private TypeReference<List<AdvertisingSettings>> LIST_REFERENCE =
            new TypeReference<List<AdvertisingSettings>>() {
            };

    protected AdvertisingSettingsMapDeserializer() {
        super(Map.class);
    }

    @Override
    public Map<AdvertisingPlacement, List<AdvertisingSettings>> deserialize(JsonParser p, DeserializationContext ctxt)
            throws IOException, JsonProcessingException {
        if (p.currentToken() == JsonToken.START_OBJECT) {
            return JsonMapping.OM.readValue(p, MAP_REFERENCE);
        } else if (p.currentToken() == JsonToken.START_ARRAY) {
            return AdvertisingSettings.adsMapFromList(JsonMapping.OM.readValue(p, LIST_REFERENCE));
        } else {
            throw new JsonMappingException(p, "Unexpected token " + p.currentToken());
        }

    }
}
