package ru.yandex.webmaster3.core.turbo.model.analytics;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.turbo.model.analytics.AnalyticsSettings.*;
import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;

/**
 * Created by Oleg Bazdyrev on 05/07/2017.
 */
public enum AnalyticsSystemType implements Discriminator<AnalyticsSettings> {

    @Description("Яндекс-метрика")
    YANDEX(AnalyticsDisplayType.ID, 1, "Yandex", MetrikaCounterSettings.class),
    @Description("Liveinternet")
    LIVEINTERNET(AnalyticsDisplayType.PARAMS, 1, "LiveInternet", LiveInternetCounterSettings.class),
    @Description("Google Analytics")
    GOOGLE(AnalyticsDisplayType.ID, 1, "Google", GoogleAnalyticsSettings.class),
    @Description("Mail.ru")
    MAILRU(AnalyticsDisplayType.ID, 1, "MailRu", MailRuAnalyticsSettings.class),
    @Description("Rambler")
    RAMBLER(AnalyticsDisplayType.ID, 1, "Rambler", RamblerAnalyticsSettings.class),
    @Description("Mediascope")
    MEDIASCOPE(AnalyticsDisplayType.ID, 1, "Mediascope", MediascopeAnalyticsSettings.class),
    CUSTOM(AnalyticsDisplayType.PARAMS, 10, "custom", CustomAnalyticsSettings.class),
    ;

    private final AnalyticsDisplayType displayType;
    private final int maxCount;
    private final String displayName;
    private final Class<? extends AnalyticsSettings> dataClass;

    AnalyticsSystemType(AnalyticsDisplayType displayType, int maxCount, String displayName,
                        Class<? extends AnalyticsSettings> dataClass) {
        this.displayType = displayType;
        this.maxCount = maxCount;
        this.displayName = displayName;
        this.dataClass = dataClass;
    }

    public AnalyticsDisplayType getDisplayType() {
        return displayType;
    }

    public int getMaxCount() {
        return maxCount;
    }

    public String getDisplayName() {
        return displayName;
    }

    @Override
    public Class<? extends AnalyticsSettings> getDataClass() {
        return dataClass;
    }
}
