package ru.yandex.webmaster3.core.turbo.model.app;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.turbo.model.TurboLogo;
import ru.yandex.webmaster3.core.turbo.model.commerce.TurboColorScheme;

/**
 * Created by Oleg Bazdyrev on 23/04/2020.
 */
@Value
@Builder(toBuilder = true)
@AllArgsConstructor(onConstructor_ = @JsonCreator)
public class TurboAppSettings {

    @JsonProperty("enabled")
    Boolean enabled;
    @JsonProperty("title")
    String title;
    @JsonProperty("description")
    String description;
    @JsonProperty("logoInfo")
    TurboLogo logoInfo;
    @JsonProperty("theme")
    String theme;
    @JsonProperty("scc_check_start_date")
    DateTime sccCheckStartDate;

    @JsonIgnore
    public String getTurboColorsString() {
        TurboColorScheme scheme = TurboColorScheme.fromString(theme);
        return scheme == null ? null : scheme.toTurboColorsString();
    }
}
