package ru.yandex.webmaster3.core.turbo.model.authorization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;

/**
 * Created by Oleg Bazdyrev on 19/03/2019.
 */
public class TurboAuthorizationSettings {

    private final String authEndpoint;
    private final String loginEndpoint;
    private final String logoutEndpoint;

    @JsonCreator
    public TurboAuthorizationSettings(@JsonProperty("authEndpoint") String authEndpoint,
                                      @JsonProperty("loginEndpoint") String loginEndpoint,
                                      @JsonProperty("logoutEndpoint") String logoutEndpoint) {
        this.authEndpoint = authEndpoint;
        this.loginEndpoint = loginEndpoint;
        this.logoutEndpoint = logoutEndpoint;
    }

    public String getAuthEndpoint() {
        return authEndpoint;
    }

    public String getLoginEndpoint() {
        return loginEndpoint;
    }

    public String getLogoutEndpoint() {
        return logoutEndpoint;
    }

    @JsonIgnore
    public boolean isAllFieldsEmpty() {
        return Strings.isNullOrEmpty(authEndpoint) &&
                Strings.isNullOrEmpty(loginEndpoint) &&
                Strings.isNullOrEmpty(logoutEndpoint);
    }
}
