package ru.yandex.webmaster3.core.turbo.model.autoparser;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Created by ifilippov5 on 18.06.18.
 */
public enum AutoparserToggleState implements IntEnum {
    @Description("Включен")
    ON(0),
    @Description("Выключен")
    OFF(1),
    @Description("Наследуется от доменов верхнего уровня")
    INHERITS(2),
    @Description("Данные отсутствуют либо несвежие")
    ABSENT(3),
    ;

    private final int value;

    AutoparserToggleState(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<AutoparserToggleState> R = IntEnumResolver.r(AutoparserToggleState.class);
}
