package ru.yandex.webmaster3.core.turbo.model.autoparser;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.turbo.model.TurboSampleData;

import java.util.List;

/**
 * Created by ifilippov5 on 18.06.18.
 */
public class TurboAutoparsedHostInfo {
    private final String host;
    private final AutoparserToggleState checkboxState;
    private final List<TurboSampleData> samples;
    private final DateTime updateDate;
    private final boolean importedFromYt;

    public TurboAutoparsedHostInfo(String host, AutoparserToggleState checkboxState, List<TurboSampleData> samples,
                                   DateTime updateDate, boolean importedFromYt) {
        this.host = host;
        this.checkboxState = checkboxState;
        this.samples = samples;
        this.updateDate = updateDate;
        this.importedFromYt = importedFromYt;
    }

    public String getHost() {
        return host;
    }

    public AutoparserToggleState getCheckboxState() {
        return checkboxState;
    }

    public List<TurboSampleData> getSamples() {
        return samples;
    }

    public DateTime getUpdateDate() {
        return updateDate;
    }

    public boolean isImportedFromYt() {
        return importedFromYt;
    }

    public TurboAutoparsedHostInfo withCheckboxState(AutoparserToggleState checkboxState) {
        return new TurboAutoparsedHostInfo(host, checkboxState, samples, updateDate, importedFromYt);
    }

    public TurboAutoparsedHostInfo withSamples(List<TurboSampleData> samples) {
        return new TurboAutoparsedHostInfo(host, checkboxState, samples, updateDate, importedFromYt);
    }
}
