package ru.yandex.webmaster3.core.turbo.model.ban;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Oleg Bazdyrev on 07/02/2018.
 * Причины бана турбо-страниц
 */
public enum TurboBanReason {

    UNKNOWN(""),
    ABUSE("ABUSE"),
    ADULT("ADULT"),
    BADCONTENT("BADCONTENT"),
    COPYRIGHT("COPYRIGHT"),
    DUPLICATE("DUPLICATE"),
    ILLEGAL("ILLEGAL"),
    INSULT("INSULT"),
    PERSONAL("PERSONAL"),
    UGLY_HTML("UGLY_HTML"),
    ;

    private final String code;
    private static final Map<String, TurboBanReason> reasonsByCode = new HashMap<>();
    static {
        for (TurboBanReason reason : TurboBanReason.values()) {
            reasonsByCode.put(reason.getCode(), reason);
        }
    }

    TurboBanReason(String code) {
        this.code = code;
    }

    public String getCode() {
        return code;
    }

    public static TurboBanReason byCode(String code) {
        return reasonsByCode.getOrDefault(code, UNKNOWN);
    }
}
