package ru.yandex.webmaster3.core.turbo.model.comments;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.EqualsAndHashCode;

/**
 * Created by Oleg Bazdyrev on 19/03/2019.
 * WMC-7070
 */
@JsonDeserialize(builder = TurboCommentsSettings.TurboCommentsSettingsBuilder.class)
@EqualsAndHashCode
public class TurboCommentsSettings {

    private final String getCommentsEndpoint;
    private final String addCommentsEndpoint;
    private final TURBO_COMMENT_STATUS status;

    @JsonCreator
    public TurboCommentsSettings(@JsonProperty("getCommentsEndpoint") String getCommentsEndpoint,
                                 @JsonProperty("addCommentsEndpoint") String addCommentsEndpoint,
                                 @JsonProperty("status") TURBO_COMMENT_STATUS status) {
        this.getCommentsEndpoint = getCommentsEndpoint;
        this.addCommentsEndpoint = addCommentsEndpoint;
        this.status = status;
    }

    public static TurboCommentsSettingsBuilder builder() {
        return new TurboCommentsSettingsBuilder();
    }

    public String getGetCommentsEndpoint() {
        return getCommentsEndpoint;
    }

    public String getAddCommentsEndpoint() {
        return addCommentsEndpoint;
    }

    public TURBO_COMMENT_STATUS getStatus() {
        return status;
    }


    public enum TURBO_COMMENT_STATUS {
        NO,
        @Deprecated(forRemoval = true)
        CMNT,
        MANUAL
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class TurboCommentsSettingsBuilder {

        private String getCommentsEndpoint;
        private String addCommentsEndpoint;
        private TURBO_COMMENT_STATUS status;

        TurboCommentsSettingsBuilder() {
        }

        public TurboCommentsSettingsBuilder getCommentsEndpoint(String getCommentsEndpoint) {
            this.getCommentsEndpoint = getCommentsEndpoint;
            return this;
        }

        public TurboCommentsSettingsBuilder addCommentsEndpoint(String addCommentsEndpoint) {
            this.addCommentsEndpoint = addCommentsEndpoint;
            return this;
        }

        public TurboCommentsSettingsBuilder status(TURBO_COMMENT_STATUS status) {
            this.status = status;
            return this;
        }

        public TurboCommentsSettings build() {
            if (status == null && getCommentsEndpoint != null && addCommentsEndpoint != null) {
                status = TURBO_COMMENT_STATUS.MANUAL;
            } else if (status == null) {
                status = TURBO_COMMENT_STATUS.NO;
            }
            return new TurboCommentsSettings(getCommentsEndpoint, addCommentsEndpoint, status);
        }
    }
}
