package ru.yandex.webmaster3.core.turbo.model.commerce;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Value;
import lombok.With;
import org.apache.commons.lang3.ObjectUtils;

/**
 * @author kravchenko99
 * @date 12/10/20
 */

@Value
@With
@AllArgsConstructor(onConstructor_ = @JsonCreator)
@JsonInclude
public class PaymentMethodSettings {

    @JsonProperty("name")
    PaymentMethodEnum name;

    @JsonProperty("description")
    String description;

    @JsonProperty("label")
    String label;

    @JsonProperty("enabled")
    boolean enabled;

    public static PaymentMethodSettings createDefault(PaymentMethodEnum method) {
        return new PaymentMethodSettings(method, null, null, false);
    }

    public static PaymentMethodSettings createDefault(PaymentMethodEnum method, boolean enabled) {
        return new PaymentMethodSettings(method, null, null, enabled);
    }

    public String getDescription() {
        return ObjectUtils.firstNonNull(description, name.getDefaultDescription());
    }

    public String getLabel() {
        return ObjectUtils.firstNonNull(label, name.getDefaultLabel());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PaymentMethodSettings that = (PaymentMethodSettings) o;
        return name == that.name;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name);
    }
}
