package ru.yandex.webmaster3.core.turbo.model.commerce;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Value;
import lombok.With;

import ru.yandex.webmaster3.core.util.json.JsonFrontendIgnore;

/**
 * Created by Oleg Bazdyrev on 11/03/2020.
 * WMC-8542: настройки оплат для плагина в Битриксе
 */
@Value
@With
@AllArgsConstructor(onConstructor_ = @JsonCreator)
@JsonInclude
public class TurboBitrixSettings {

    @JsonProperty("enabled")
    boolean enabled;
    @JsonProperty("token")
    String token;
    @JsonFrontendIgnore
    @JsonProperty("encryptedToken")
    String encryptedToken;
    @JsonProperty("apiBaseUrl")
    String apiBaseUrl;

}
