package ru.yandex.webmaster3.core.turbo.model.commerce;

import java.util.Arrays;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.Value;

import ru.yandex.webmaster3.core.util.json.JsonMapping;

/**
 * Created by Oleg Bazdyrev on 16/06/2020.
 * Цветовая схема турбо-магазина
 */
@Value
@Builder
@AllArgsConstructor(onConstructor_ = @JsonCreator)
public class TurboColorScheme {

    @JsonProperty("type")
    Type type;
    @JsonProperty("colorBrand")
    String colorBrand;
    @JsonProperty("colorActionButtonText")
    String colorActionButtonText;
    @JsonProperty("colorDiscount")
    String colorDiscount;
    @JsonProperty("colorBottombarActive")
    String colorBottombarActive;

    @Getter
    @AllArgsConstructor
    public enum Type {
        BLUE("blue"),
        GREEN("green"),
        BLACK("black"),
        RED("red"),
        VIOLET("violet"),
        PINK("pink"),
        CUSTOM(null),
        ;

        private final String color;
    }

    public String toTurboColorsString() {
        if (type == null) {
            return null;
        }
        if (type != Type.CUSTOM) {
            return "--color-brand: var(--shop-" + type.color + ")";
        }
        // CUSTOM
        StringBuilder result = new StringBuilder(128);
        String newColorBrand = Strings.isNullOrEmpty(colorBrand) ? "217FF7" : colorBrand;
        result.append("--color-brand: #").append(newColorBrand).append(";");// 217FF7

        String newColorActionButtonText = Strings.isNullOrEmpty(colorActionButtonText) ? "ffffff" : colorActionButtonText;
        result.append("--color-action-button-text: #").append(newColorActionButtonText).append(";"); // ffffff

        String newColorDiscount = Strings.isNullOrEmpty(colorDiscount) ? "F93942" : colorDiscount;
        result.append("--color-discount: #").append(newColorDiscount).append(";"); // F93942

//        String newColorBottombarActive = Strings.isNullOrEmpty(colorBottombarActive) ? "217FF7" : colorBottombarActive;
//        result.append("--color-bottombar-active: #").append(newColorBottombarActive).append(";"); // don't implemented

        return result.toString();
    }

    // TODO убрать поддержку старого формата
    public static TurboColorScheme fromString(String value) {
        if (Strings.isNullOrEmpty(value)) {
            return null;
        }
        try {
            return JsonMapping.readValue(value, TurboColorScheme.class);
        } catch (Exception e) {
            // попытаемся прочитать хотя бы color-brand из строка вида "--color-brand: #212121;--color-bg-start: #000000;--color-bg-stop: #000000"
            return Arrays.stream(value.split(";")).filter(s -> s.startsWith("--color-brand")).map(s -> s.substring(s.length() - 6)).findAny()
                    .map(s -> TurboColorScheme.builder().type(Type.CUSTOM).colorBrand(s).build()).orElse(null);
        }
    }
}
