package ru.yandex.webmaster3.core.turbo.model.commerce;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;

import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * Created by Oleg Bazdyrev on 03/09/2018.
 * Информационный раздел для e-commerce в турбо
 */
@Getter
@AllArgsConstructor(onConstructor_ = @JsonCreator)
@EqualsAndHashCode(of = {"title"})
public class TurboCommerceInfoSection {
    @Description("Название раздела")
    @JsonProperty("title")
    private final String title;
    @Description("Содержимое раздела")
    @JsonProperty("value")
    private final String value;

}
