package ru.yandex.webmaster3.core.turbo.model.commerce;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.turbo.model.TurboLogo;
import ru.yandex.webmaster3.core.turbo.model.commerce.delivery.DeliverySection;

/**
 * Created by Oleg Bazdyrev on 17/06/2020.
 * Объединение TurboApp и старых TurboCommerceSettings
 * TODO все это временное решение на период разделения настроек
 */
@Value
@Builder(toBuilder = true)
@AllArgsConstructor(onConstructor_ = @JsonCreator)
public final class TurboNewCommerceSettings {
    // from TurboAppSettings
    @JsonProperty("enabled")
    @Description("Включенность Турбо-аппа")
    Boolean enabled;
    @JsonProperty("title")
    @Description("Название магазина")
    String title;
    @JsonProperty("description")
    @Description("Краткое описание магазина")
    String description;
    @JsonProperty("logoInfo")
    @Description("Квадратный логотип магазина")
    TurboLogo logoInfo;
    @JsonProperty("marketRatingShow")
    @Builder.Default
    Boolean marketRatingShow = true;
    @JsonProperty("theme")
    @Description("Цветовая тема")
    TurboColorScheme theme;
    // from TurboCommerceSettings
    @JsonProperty("cartUrl")
    @Description("url корзины")
    String cartUrl;
    @JsonProperty("cartUrlType")
    @Description("Тип урла корзины (исключительно для фронта)")
    CartUrlType cartUrlType;
    @JsonProperty("cartUrlEnabled")
    @Description("Включены ли покупки при помощи кнопки В корзину")
    boolean cartUrlEnabled;
    @JsonProperty("checkoutEmail")
    @Description("Емейл для покупок в один клик (и для турбо-корзины)")
    String checkoutEmail;
    @JsonProperty("checkoutEmailEnabled")
    @Description("Включены ли покупки в один клик")
    Boolean checkoutEmailEnabled;
    @JsonProperty("infoSections")
    @Description("список информационных секций")
    List<TurboCommerceInfoSection> infoSections;
    @JsonProperty("parsedAccordion")
    @Description("Распаршенный аккордеон, нужен только внутреннего потребления, на фронте никак отображать не надо")
    JsonNode parsedAccordion;
    @JsonProperty("turboCartEnabled")
    @Description("Включена ли турбо-корзина")
    Boolean turboCartEnabled;
    @JsonProperty("turboListingsEnabled")
    @Description("Включены ли турбо-листинги")
    Boolean turboListingsEnabled;
    @JsonProperty("paymentsSettings")
    @Description("Настройки Яндекс-оплат")
    TurboPaymentsSettings paymentsSettings;
    @JsonProperty("deliverySection")
    @Description("Список возможны доставок")
    DeliverySection deliverySection;
    @JsonProperty("autoMorda")
    @Description("Включена ли автоглавная для екоммерс")
    Boolean autoMorda;
    @JsonProperty("bitrixSettings")
    @Description("Настройки интеграции с Битриксом")
    TurboBitrixSettings bitrixSettings;
    @JsonProperty("feedbackPhone")
    @Description("Телефон для обратной связи")
    String feedbackPhone;
    @JsonProperty("feedbackEmail")
    @Description("Емейл для обратной связи")
    String feedbackEmail;
    @Description("Включение доставок маркета в интерфейсе вебмастера")
    Boolean marketDeliveryEnabled;
}
