package ru.yandex.webmaster3.core.turbo.model.commerce;

import java.util.Collections;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.With;
import org.apache.curator.shaded.com.google.common.base.Objects;
import org.joda.time.DateTime;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.blackbox.UserWithLogin;
import ru.yandex.webmaster3.core.payments.ServiceMerchantInfo;

/**
 * Created by Oleg Bazdyrev on 2019-05-29.
 */
@Getter
@With
@Builder(toBuilder = true)
public class TurboPaymentsSettings {

    @JsonProperty("enabled")
    private final boolean enabled;
    @JsonProperty("token")
    @Description("Токен Яндекс.Оплат")
    private final String token;
    @JsonProperty("merchantInfo")
    @Description("Информация о магазине из Яндекс.Оплат")
    private final ServiceMerchantInfo merchantInfo;
    @JsonProperty("defaultVat")
    @Description("НДС по умолчанию (если не указано в фиде)")
    private final VATValueEnum defaultVat;
    @JsonProperty("editUser")
    private final UserWithLogin editUser;
    @JsonProperty("editDate")
    private final DateTime editDate;
    @JsonProperty("paymentMethods")
    private final Set<PaymentMethodSettings> paymentMethods;

    @JsonCreator
    public TurboPaymentsSettings(@JsonProperty("enabled") boolean enabled,
                                 @JsonProperty("token") String token,
                                 @JsonProperty("merchantInfo") ServiceMerchantInfo merchantInfo,
                                 @JsonProperty("defaultVat") VATValueEnum defaultVat,
                                 @JsonProperty("editUser") UserWithLogin editUser,
                                 @JsonProperty("editDate") DateTime editDate,
                                 @JsonProperty("paymentMethods") Set<PaymentMethodSettings> paymentMethods) {
        this.enabled = enabled;
        this.token = token;
        this.merchantInfo = merchantInfo;
        this.defaultVat = Objects.firstNonNull(defaultVat, VATValueEnum.NO_VAT);
        this.editUser = editUser;
        this.editDate = editDate;
        this.paymentMethods = Objects.firstNonNull(paymentMethods, Collections.emptySet());
    }
}
