package ru.yandex.webmaster3.core.turbo.model.commerce.delivery;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.RequiredArgsConstructor;
import lombok.Value;

/**
 * @author: ishalaru
 * DATE: 10.07.2019
 */
@Value
@Builder(toBuilder = true)
@RequiredArgsConstructor(onConstructor_ = @JsonCreator)
public class CourierDeliverySettings implements DeliverySettings {
    @JsonProperty("name")
    String name;
    @JsonProperty("minDeliveryPeriod")
    int minDeliveryPeriod;
    @JsonProperty("maxDeliveryPeriod")
    int maxDeliveryPeriod;
    @JsonProperty("price")
    BigDecimal price;
    @JsonProperty("freeFrom")
    BigDecimal freeFrom;

    @Override
    public void validate(String prefix) {
        validateDeliveryDays(prefix, minDeliveryPeriod, maxDeliveryPeriod);
        validatePrice(prefix, price);
        validateFreeFrom(prefix, freeFrom);
    }
}
