package ru.yandex.webmaster3.core.turbo.model.commerce.delivery;

import ru.yandex.webmaster3.core.turbo.model.commerce.delivery.exception.DeliverySettingsException;

import java.math.BigDecimal;

/**
 * @author: ishalaru
 * DATE: 10.07.2019
 */
public interface DeliverySettings {
    void validate(String prefix);

    default DeliverySettingsException invalidParamValue(String message, String param, String value) {
        return new DeliverySettingsException(param, value,message);
    }

    default void validatePrice(String prefix, BigDecimal price) {
        if (price == null) {
            throw invalidParamValue("Delivery price doesn't init", prefix + ".price", null);
        }
        if (price.compareTo(BigDecimal.ZERO) < 0) {
            throw invalidParamValue("Delivery price can't be negative", prefix + ".price", price.toString());
        }

    }

    default void validateFreeFrom(String prefix, BigDecimal freeFrom) {
        if (freeFrom == null) {
            return;
        }
        if (freeFrom.compareTo(BigDecimal.ZERO) < 0) {
            throw invalidParamValue("Free delivery sum can't be negative", prefix + ".freeFrom", freeFrom.toString());
        }
    }

    default void validateDeliveryDays(String prefix, int minDeliveryPeriod, int maxDeliveryPeriod) {
        if (minDeliveryPeriod < 0) {
            throw invalidParamValue("Incorrect min delivery days in e-commerce delivery sections", prefix + ".minDeliveryPeriod",
                    String.valueOf(minDeliveryPeriod));
        }
        if (maxDeliveryPeriod < 0) {
            throw invalidParamValue("Incorrect max delivery days in e-commerce delivery sections", prefix + ".maxDeliveryPeriod",
                    String.valueOf(maxDeliveryPeriod));
        }
        if (minDeliveryPeriod > maxDeliveryPeriod) {
            throw invalidParamValue("Min delivery days can't be more than max delivery days", prefix + ".(minDeliveryPeriod,maxDeliveryPeriod)", String.valueOf(minDeliveryPeriod) +","+ String.valueOf(maxDeliveryPeriod));
        }
    }
}
