package ru.yandex.webmaster3.core.turbo.model.desktop;

import java.util.Set;

import com.fasterxml.jackson.core.type.TypeReference;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * Created by Oleg Bazdyrev on 18/02/2019.
 */
public enum TurboDesktopColumn {

    LEFT("left"),
    MAIN("main"),
    RIGHT("right"),
    ;

    private final String displayName;

    TurboDesktopColumn(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return displayName;
    }

    public static final EnumResolver<TurboDesktopColumn> R = EnumResolver.er(TurboDesktopColumn.class);
    public static final TypeReference<Set<TurboDesktopColumn>> SET_REFERENCE = new TypeReference<>() {
    };
}
