package ru.yandex.webmaster3.core.turbo.model.error;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.collections4.ComparatorUtils;
import ru.yandex.autodoc.common.doc.annotation.Description;

import java.util.Comparator;
import java.util.Objects;

/**
 * Пример ошибки
 */
public final class TurboErrorSample {

    private final Integer line;
    private final Integer column;
    private final String text;
    private final ObjectNode params;

    public TurboErrorSample(Integer line, Integer column, String text, ObjectNode params) {
        this.line = line;
        this.column = column;
        this.text = text;
        this.params = params;
    }

    @Description("Номер строки с ошибкой")
    @JsonProperty("lineNumber")
    public Integer getLine() {
        return line;
    }

    @Description("Номер столбца с ошибкой")
    @JsonProperty("posNumber")
    public Integer getColumn() {
        return column;
    }

    @Description("Строка с ошибкой")
    @JsonProperty("message")
    public String getText() {
        return text;
    }

    @Description("Дополнительные параметры ошибки")
    public ObjectNode getParams() {
        return params;
    }

    public static final Comparator<TurboErrorSample> BY_LINE = Comparator.comparing(
            TurboErrorSample::getLine, ComparatorUtils.nullLowComparator(null));

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TurboErrorSample that = (TurboErrorSample) o;
        return Objects.equals(line, that.line) &&
                Objects.equals(column, that.column) &&
                Objects.equals(text, that.text) &&
                Objects.equals(params, that.params);
    }

    @Override
    public int hashCode() {
        return Objects.hash(line, column, text);
    }
}
