package ru.yandex.webmaster3.core.turbo.model.error;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * Created by Oleg Bazdyrev on 08/10/2018.
 */
public enum TurboSeverity {

    INFO(false),
    WARNING(false),
    ERROR(true),
    ;

    private final boolean isFatal;

    TurboSeverity(boolean isFatal) {
        this.isFatal = isFatal;
    }

    public boolean isFatal() {
        return isFatal;
    }

    public static final EnumResolver<TurboSeverity> R = EnumResolver.er(TurboSeverity.class);
}
