package ru.yandex.webmaster3.core.turbo.model.feed;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Created by ifilippov5 on 22.05.18.
 */
public enum TurboApiContentState implements IntEnum {

    @Description("Контент прогружается")
    DOWNLOADING(0, false),
    @Description("Контент прогружен")
    LOADED(1, true),
    @Description("Контент удален и никак не отображается в UI")
    DELETED(2, false),
    ;

    private final int value;
    private final boolean displayable; //отображаем ли в UI

    TurboApiContentState(int value, boolean displayable) {
        this.value = value;
        this.displayable = displayable;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isDisplayable() {
        return displayable;
    }

    public static IntEnumResolver<TurboApiContentState> R = IntEnumResolver.r(TurboApiContentState.class);
}
