package ru.yandex.webmaster3.core.turbo.model.feed;

import java.util.List;
import java.util.UUID;

import com.datastax.driver.core.utils.UUIDs;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.turbo.model.TurboUrl;
import ru.yandex.webmaster3.core.turbo.model.error.TurboRawError;

/**
 * Created by ifilippov5 on 21.05.18.
 */
public class TurboApiFullTaskResult {
    private final UUID taskId;
    private final List<TurboUrl> turboUrls;
    private final List<TurboRawError> rawErrors;
    private final TurboFeedItemStatistics stats;
    private final String hash;
    private final DateTime importDate; // дата, когда результаты попали в кассандру

    public TurboApiFullTaskResult(TurboApiTaskWithResult result, List<TurboUrl> urls, List<TurboRawError> errors) {
        this(result.getTaskId(), urls, errors, result.getStats(), result.getHash(), result.getImportDate());
    }

    public TurboApiFullTaskResult(UUID taskId, List<TurboUrl> turboUrls, List<TurboRawError> rawErrors,
                                  TurboFeedItemStatistics stats, String hash, DateTime importDate) {
        this.taskId = taskId;
        this.turboUrls = turboUrls;
        this.rawErrors = rawErrors;
        this.stats = stats;
        this.hash = hash;
        this.importDate = importDate;
    }

    public UUID getTaskId() {
        return taskId;
    }

    public List<TurboUrl> getTurboUrls() {
        return turboUrls;
    }

    public DateTime getDownloadDate() {
        return new DateTime(UUIDs.unixTimestamp(taskId));
    }

    public List<TurboRawError> getRawErrors() {
        return rawErrors;
    }

    public TurboFeedItemStatistics getStats() {
        return stats;
    }

    public String getHash() {
        return hash;
    }

    public TurboCrawlState getState() {
        // нет ни одного турбо-урла - ошибка
        if (CollectionUtils.isEmpty(turboUrls) && (stats == null || stats.getValid() == 0)) {
            return TurboCrawlState.ERROR;
        }
        // если есть ошибки - предупреждение
        if (!CollectionUtils.isEmpty(rawErrors)) {
            return TurboCrawlState.WARNING;
        }
        // иначе все ок
        return TurboCrawlState.OK;
    }

    public DateTime getImportDate() {
        return importDate;
    }
}
