package ru.yandex.webmaster3.core.turbo.model.feed;

import java.util.List;
import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import org.joda.time.DateTime;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.turbo.model.TurboUrl;
import ru.yandex.webmaster3.core.turbo.model.error.TurboRawError;

/**
 * Created by iceflame
 */
@Value
@Builder(toBuilder = true)
@AllArgsConstructor
public class TurboApiTaskWithResult implements TurboFeedSettingsInfo {

    String owner;
    WebmasterHostId hostId;
    DateTime addDate; //дата создания таски
    UUID taskId;
    boolean active;
    TurboCrawlState state;
    String hash;
    DateTime importDate;
    TurboFeedItemStatistics stats;
    List<TurboUrl> urls;
    List<TurboRawError> errors;

    public TurboApiTaskWithResult(String owner,
                                  WebmasterHostId hostId,
                                  DateTime addDate,
                                  UUID taskId,
                                  boolean active,
                                  TurboCrawlState state,
                                  String hash,
                                  DateTime importDate,
                                  TurboFeedItemStatistics stats) {
        this(owner, hostId, addDate, taskId, active, state, hash, importDate, stats, null, null);
    }

    @Description("Тип источника")
    public TurboFeedType getType() {
        return TurboFeedType.API;
    }

}
