package ru.yandex.webmaster3.core.turbo.model.feed;

import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Created by Oleg Bazdyrev on 09/06/2018.
 */
@AllArgsConstructor
public enum TurboCrawlState implements IntEnum {
    OK(0, "valid"),
    WARNING(1, "warning"),
    ERROR(2, "error"),
    PROCESSING(3, "processing")
    ;
    private final int value;
    @Getter
    private final String label;

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<TurboCrawlState> R = IntEnumResolver.r(TurboCrawlState.class);
}
