package ru.yandex.webmaster3.core.turbo.model.feed;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;

import java.util.Objects;

/**
 * Статистика по item-ам внутри турбо-фида
 * Created by Oleg Bazdyrev on 07/11/2017.
 */
public class TurboFeedItemStatistics {

    public static final TurboFeedItemStatistics EMPTY = new TurboFeedItemStatistics(0, 0, 0, 0);

    private final int total;
    private final int error;
    private final int warning;
    private final int valid;

    @JsonCreator
    public TurboFeedItemStatistics(@JsonProperty("total") int total,
                                   @JsonProperty("error") int error,
                                   @JsonProperty("warning") int warning,
                                   @JsonProperty("valid") int valid) {
        this.total = total;
        this.error = error;
        this.warning = warning;
        this.valid = valid;
    }

    public int getTotal() {
        return total;
    }

    public int getError() {
        return error;
    }

    public int getWarning() {
        return warning;
    }

    public int getValid() {
        return valid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TurboFeedItemStatistics that = (TurboFeedItemStatistics) o;
        return total == that.total &&
                error == that.error &&
                warning == that.warning &&
                valid == that.valid;
    }

    @Override
    public int hashCode() {
        return Objects.hash(total, error, warning, valid);
    }

    public static TurboFeedItemStatistics fromObjectNode(ObjectNode stats) {
        if (stats != null) {
            int ok = stats.get("ok").intValue();
            int error = stats.get("error").intValue();
            int warning = stats.get("warning").intValue();
            int info = stats.get("info").intValue();
            int total = ok + error + warning + info;
            return total == 0 ? null : new TurboFeedItemStatistics(total, error, warning, ok + info);
        } else {
            return EMPTY;
        }
    }
}
