package ru.yandex.webmaster3.core.turbo.model.feed;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.EnumResolver;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Статус источника-турбо
 * Created by Oleg Bazdyrev on 26/07/2017.
 */
public enum TurboFeedState {

    UNKNOWN(-1, false),
    @Description("Источник добавлен")
    NEW(1, true),
    @Description("Источник проверяется")
    VALIDATING(2, true),
    @Description("Ошибка валидации")
    VALIDATION_ERROR(3, true),
    @Description("Источник прогружается")
    DOWNLOADING(4, true),
    @Description("Источник удален и никак не отображается в UI")
    DELETED(7, true),
    ;

    private final int value;
    private final boolean exportable;

    TurboFeedState(int value, boolean exportable) {
        this.value = value;
        this.exportable = exportable;
    }

    public boolean isExportable() {
        return exportable;
    }

    public static EnumResolver<TurboFeedState> R = EnumResolver.er(TurboFeedState.class);
}
