package ru.yandex.webmaster3.core.turbo.model.feed;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.turbo.model.TurboUrl;
import ru.yandex.webmaster3.core.turbo.model.error.TurboError;
import ru.yandex.webmaster3.core.turbo.model.error.TurboRawError;

import java.util.List;
import java.util.UUID;

/**
 * Created by Oleg Bazdyrev on 09/06/2018.
 */
public interface TurboFeedStatisticsInfo {
    default String getUrl() {
        return null;
    }

    default UUID getTaskId() {
        return null;
    }

    TurboFeedItemStatistics getStats();

    DateTime getDownloadDate();

    default DateTime getUpdateDate() {
        return null;
    }

    String getHash();

    List<TurboUrl> getTurboUrls();

    List<TurboError> getErrors();

    List<TurboRawError> getRawErrors();

    TurboCrawlState getState();
}
