package ru.yandex.webmaster3.core.turbo.model.feed;

import java.util.HashMap;
import java.util.Map;

import lombok.Getter;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Created by Oleg Bazdyrev on 28/07/2017.
 */
@Description("Тип источника турбо-превью страницы")
public enum TurboFeedType implements IntEnum {

    UNKNOWN(-1, false, null, false),
    // Робот
    AUTO(0, false, "autoparser", false),
    // RSS-like фид
    RSS(1, true, "rss", false),
    // YML?
    YML(2, true, "yml", true),
    // Некий внешний источник
    // EXTERNAL(3, false, "external"),
    // Загружен через апи вебмастера
    API(4, false, "api", false),
    // Савтопаршен, но автопарсер выключен
    AUTO_DISABLED(5, false, "autoparser_button", false),
    JSON_API(6, false, "json_api", false),
    YML_LISTING(7, true, "yml_listing", true),
    AUTO_MORDA(8, true, "auto_morda", false),
    ;

    private final int value;
    private final boolean internal;
    private final String code;
    @Getter
    private final boolean yml;

    private static final Map<String, TurboFeedType> typesByCode = new HashMap<>();
    static {
        for (TurboFeedType type : TurboFeedType.values()) {
            typesByCode.put(type.getCode(), type);
        }
    }

    TurboFeedType(int value, boolean internal, String code, boolean yml) {
        this.value = value;
        this.internal = internal;
        this.code = code;
        this.yml = yml;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isInternal() {
        return internal;
    }

    public String getCode() {
        return code;
    }

    public boolean isAutoparser() {
        return this == AUTO || this == AUTO_DISABLED;
    }

    public static TurboFeedType byCode(String code) {
        return typesByCode.getOrDefault(code, UNKNOWN);
    }

    public static final IntEnumResolver<TurboFeedType> R = IntEnumResolver.r(TurboFeedType.class);
}
