package ru.yandex.webmaster3.core.turbo.model.feedback;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;

/**
 * Created by Oleg Bazdyrev on 21/06/2018.
 */
@Builder
public class TurboFeedbackButton {

    private final TurboFeedbackButtonType type;
    private final String url;
    private final String sendTo;
    private final String agreementCompany;
    private final String agreementLink;

    public TurboFeedbackButton(@JsonProperty("type") TurboFeedbackButtonType type,
                               @JsonProperty("url") String url,
                               @JsonProperty("sendTo") String sendTo,
                               @JsonProperty("agreementCompany") String agreementCompany,
                               @JsonProperty("agreementLink") String agreementLink) {
        this.type = type;
        this.url = url;
        this.sendTo = sendTo;
        this.agreementCompany = agreementCompany;
        this.agreementLink = agreementLink;
    }

    public TurboFeedbackButtonType getType() {
        return type;
    }

    public String getUrl() {
        return url;
    }

    public String getSendTo() {
        return sendTo;
    }

    public String getAgreementCompany() {
        return agreementCompany;
    }

    public String getAgreementLink() {
        return agreementLink;
    }

    public TurboFeedbackButton withUrl(String url) {
        return new TurboFeedbackButton(type, url, sendTo, agreementCompany, agreementLink);
    }

    public TurboFeedbackButton withAgreementLink(String agreementLink) {
        return new TurboFeedbackButton(type, url, sendTo, agreementCompany, agreementLink);
    }

    public static TurboFeedbackButton chat() {
        return new TurboFeedbackButton(TurboFeedbackButtonType.CHAT, null, null, null, null);
    }

}
