package ru.yandex.webmaster3.core.turbo.model.feedback;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.turbo.model.TurboUserAgreement;

import java.util.List;

/**
 * Created by Oleg Bazdyrev on 21/06/2018.
 * Настройки блока обратной связи
 */
public class TurboFeedbackSettings {

    private final Stick stick;
    private final List<TurboFeedbackButton> buttons;

    public TurboFeedbackSettings(@JsonProperty("stick") Stick stick,
                                 @JsonProperty("buttons") List<TurboFeedbackButton> buttons) {
        this.stick = stick;
        this.buttons = buttons;
    }

    @Description("Куда должен прилипать блок обратной связи")
    public Stick getStick() {
        return stick;
    }

    @Description("Кнопки для блока обратно связи")
    public List<TurboFeedbackButton> getButtons() {
        return buttons;
    }

    @JsonIgnore
    public TurboUserAgreement findUserAgreement() {
        if (buttons == null) {
            return null;
        }
        return buttons.stream()
                .filter(button -> button.getType() == TurboFeedbackButtonType.CALLBACK)
                .filter(button -> !Strings.isNullOrEmpty(button.getAgreementCompany()))
                .filter(button -> !Strings.isNullOrEmpty(button.getAgreementLink()))
                .map(button -> new TurboUserAgreement(button.getAgreementCompany(), button.getAgreementLink()))
                .findAny().orElse(null);
    }

    public enum Stick {
        LEFT,
        RIGHT,
    }

}
