package ru.yandex.webmaster3.core.turbo.model.landing;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.jetbrains.annotations.NotNull;
import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * Created by Oleg Bazdyrev on 12/11/2018.
 */
public class TurboLandingPreview implements Comparable<TurboLandingPreview> {

    private final int orderId;
    private final String label;
    private final String previewUrl;

    public TurboLandingPreview(int orderId, String label, String previewUrl) {
        this.orderId = orderId;
        this.label = label;
        this.previewUrl = previewUrl;
    }

    @JsonIgnore
    public int getOrderId() {
        return orderId;
    }

    @Description("Название сайта")
    public String getLabel() {
        return label;
    }

    @Description("Ссылка на турбо-превью")
    public String getPreviewUrl() {
        return previewUrl;
    }

    @Override
    public int compareTo(@NotNull TurboLandingPreview o) {
        return Integer.compare(orderId, o.orderId);
    }
}
