package ru.yandex.webmaster3.core.turbo.model.menu;

import java.io.IOException;
import java.util.List;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;

import ru.yandex.webmaster3.core.util.json.JsonMapping;

/**
 * Created by Oleg Bazdyrev on 18/02/2020.
 */
public class AutoMenuSettingsDeserializer extends StdDeserializer<List<TurboMenuItem>> {

    private TypeReference<List<TurboMenuItem>> LIST_REFERENCE =
            new TypeReference<List<TurboMenuItem>>() {
            };

    protected AutoMenuSettingsDeserializer() {
        super(List.class);
    }

    @Override
    public List<TurboMenuItem> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (p.currentToken() == JsonToken.START_ARRAY) {
            return JsonMapping.OM.readValue(p, LIST_REFERENCE);
        } else if (p.currentToken() == JsonToken.VALUE_STRING) {
            return JsonMapping.OM.readValue(p.getValueAsString(), LIST_REFERENCE);
        } else {
            throw new JsonMappingException(p, "Unexpected token " + p.currentToken());
        }
    }
}
