package ru.yandex.webmaster3.core.turbo.model.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Created by Oleg Bazdyrev on 18/02/2019.
 */
public class TurboSearchSettings {

    private final String url;
    private final String charset;
    private final String placeholder;

    @JsonCreator
    public TurboSearchSettings(@JsonProperty("url") String url,
                               @JsonProperty("charset") String charset,
                               @JsonProperty("placeholder") String placeholder) {
        this.url = url;
        this.charset = charset;
        this.placeholder = placeholder;
    }

    public String getUrl() {
        return url;
    }

    public String getCharset() {
        return charset;
    }

    public String getPlaceholder() {
        return placeholder;
    }
}
