package ru.yandex.webmaster3.core.turbo.model.statistics;

import java.util.List;

import lombok.Value;

/**
 * Created by Oleg Bazdyrev on 20/12/2018.
 */
@Value
public class TurboClicksStatistics {

    private final String domain;
    private final long totalClicks;
    private final long turboClicks;
    private final long autoparsedClicks;
    private final List<String> topUrlsWithoutTurbo;

    public TurboClicksStatistics(String domain, long totalClicks, long turboClicks, long autoparsedClicks,
                                 List<String> topUrlsWithoutTurbo) {
        this.domain = domain;
        this.totalClicks = totalClicks;
        this.turboClicks = turboClicks;
        this.autoparsedClicks = autoparsedClicks;
        this.topUrlsWithoutTurbo = topUrlsWithoutTurbo;
    }


}
