package ru.yandex.webmaster3.core.turbo.model.statistics;

import com.google.common.base.Strings;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedType;

/**
 * Created by Oleg Bazdyrev on 06/02/2018.
 */
public class TurboDomainStatistics {

    private final String domain;
    private final TurboFeedType source;
    private final String feed;
    private final TurboHostStatisticsType type;
    private final long value;
    private final DateTime updateDate;

    public TurboDomainStatistics(String domain, TurboFeedType source, String feed,
                                 TurboHostStatisticsType type, long value) {
        this(domain, source, feed, type, value, null);
    }

    public TurboDomainStatistics(String domain, TurboFeedType source, String feed,
                                 TurboHostStatisticsType type, long value, DateTime updateDate) {
        this.domain = domain;
        this.source = source;
        this.feed = Strings.nullToEmpty(feed);
        this.type = type;
        this.value = value;
        this.updateDate = updateDate;
    }

    public String getDomain() {
        return domain;
    }

    public TurboFeedType getSource() {
        return source;
    }

    public String getFeed() {
        return feed;
    }

    public TurboHostStatisticsType getType() {
        return type;
    }

    public long getValue() {
        return value;
    }

    public DateTime getUpdateDate() {
        return updateDate;
    }

    public TurboDomainStatistics withValue(long value) {
        return new TurboDomainStatistics(domain, source, feed, type, value, updateDate);
    }
}
