package ru.yandex.webmaster3.core.turbo.model.statistics;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * Created by Oleg Bazdyrev on 06/02/2018.
 */
public enum TurboHostStatisticsType implements IntEnum {

    PERSISTED(0),
    DELETED(1),
    BANNED(2);

    private final int value;

    TurboHostStatisticsType(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public final static IntEnumResolver<TurboHostStatisticsType> R = IntEnumResolver.r(TurboHostStatisticsType.class);
}
