package ru.yandex.webmaster3.core.turbo.model.statistics;

import java.util.Collections;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

import ru.yandex.webmaster3.core.turbo.model.TurboSource;

/**
 * Created by Oleg Bazdyrev on 23/04/2019.
 */
@Value
@Builder
@AllArgsConstructor
public final class TurboSearchUrlsStats {

    public static final TurboSearchUrlsStats EMPTY = TurboSearchUrlsStats.builder().urlsBySource(Collections.emptyMap()).build();

    long turboUrls;
    long turboSearchUrls;
    long turboSearchUrlsNoAP;
    // by sources
    Map<TurboSource, Long> urlsBySource;

}
