package ru.yandex.webmaster3.core.turbo.model.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Created by Oleg Bazdyrev on 13/02/2018.
 * Общая статистика по фиду/хосту/автопарсеру и т.п.
 */
public class TurboTotalStatistics {

    public static final TurboTotalStatistics EMPTY = new TurboTotalStatistics(0L, 0L, 0L);

    private final long saved;
    private final long deleted;
    private final long banned;

    @JsonCreator
    public TurboTotalStatistics(@JsonProperty("saved") long saved,
                                @JsonProperty("deleted") long deleted,
                                @JsonProperty("banned") long banned) {
        this.saved = saved;
        this.deleted = deleted;
        this.banned = banned;
    }

    public long getSaved() {
        return saved;
    }

    public long getDeleted() {
        return deleted;
    }

    public long getBanned() {
        return banned;
    }

    public static final class TurboTotalStatisticsBuilder {

        private long saved = 0L;
        private long deleted = 0L;
        private long banned = 0L;

        public void add(TurboDomainStatistics hostStatistics) {
            switch (hostStatistics.getType()) {
                case PERSISTED:
                    saved += hostStatistics.getValue();
                    break;
                case DELETED:
                    deleted += hostStatistics.getValue();
                    break;
                case BANNED:
                    banned += hostStatistics.getValue();
                    break;
            }
        }

        public TurboTotalStatistics build() {
            return new TurboTotalStatistics(saved, deleted, banned);
        }

        public TurboTotalStatistics buildWithoutDeleted() {
            return new TurboTotalStatistics(saved, 0, banned);
        }

    }
}
