package ru.yandex.webmaster3.core.url.checker3;

import NUrlChecker.Request;
import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author leonidrom
 */
public enum UrlCheckDeviceType {
    DESKTOP(Request.TUrlCheckRequest.EDeviceType.EDT_DESKTOP),
    MOBILE(Request.TUrlCheckRequest.EDeviceType.EDT_MOBILE),
    ;

    private final NUrlChecker.Request.TUrlCheckRequest.EDeviceType robotDeviceType;

    UrlCheckDeviceType(Request.TUrlCheckRequest.EDeviceType robotDeviceType) {
        this.robotDeviceType = robotDeviceType;
    }

    public Request.TUrlCheckRequest.EDeviceType getRobotDeviceType() {
        return robotDeviceType;
    }

    public static EnumResolver<UrlCheckDeviceType> R = EnumResolver.er(UrlCheckDeviceType.class);
}
