package ru.yandex.webmaster3.core.url.checker3;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Getter;
import lombok.With;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.mobile.data.ScreenshotResolution;
import ru.yandex.webmaster3.core.zora.ZoraUserAgent;

/**
 * @author leonidrom
 */
@Getter
public class UrlCheckRequestParams {
    public UrlCheckDeviceType deviceType;
    @With
    public String url;
    public ZoraUserAgent userAgent;
    public DateTime ifModifiedSince;

    public int screenshotWidth;
    public int screenshotHeight;

    public UrlCheckRequestParams() {
        this.deviceType = null;
        this.url = null;
        this.userAgent = ZoraUserAgent.ROBOT;
        this.ifModifiedSince = null;
        this.screenshotWidth = 0;
        this.screenshotHeight = 0;
    }

    @JsonCreator
    public UrlCheckRequestParams(
            UrlCheckDeviceType deviceType,
            String url,
            ZoraUserAgent userAgent,
            DateTime ifModifiedSince,
            int screenshotWidth,
            int screenshotHeight) {
        this.deviceType = deviceType;
        this.url = url;
        this.userAgent = userAgent;
        this.ifModifiedSince = ifModifiedSince;
        this.screenshotWidth = screenshotWidth;
        this.screenshotHeight = screenshotHeight;
    }

    public int getScreenshotWidth() {
        if (screenshotWidth != 0) {
            return screenshotWidth;
        }

        return switch (deviceType) {
            case DESKTOP -> 1280;
            case MOBILE -> 320;
        };
    }

    public int getScreenshotHeight() {
        if (screenshotHeight != 0) {
            return screenshotHeight;
        }

        return switch (deviceType) {
            case DESKTOP -> 720;
            case MOBILE -> 460;
        };
    }
}
