package ru.yandex.webmaster3.core.user;

import lombok.With;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.host.verification.VerificationType;

/**
 * @author aherman
 */
@With
public class UserVerifiedHost {
    private final WebmasterHostId webmasterHostId;
    private final DateTime verificationDate;
    private final DateTime verifiedUntilDate;
    private final long verificationUin;
    private final VerificationType verificationType;

    public UserVerifiedHost(WebmasterHostId webmasterHostId, DateTime verificationDate,
                            DateTime verifiedUntilDate, long verificationUin,
                            @NotNull VerificationType verificationType) {
        this.webmasterHostId = webmasterHostId;
        this.verificationDate = verificationDate;
        this.verifiedUntilDate = verifiedUntilDate;
        this.verificationUin = verificationUin;
        this.verificationType = verificationType;
    }

    public WebmasterHostId getWebmasterHostId() {
        return webmasterHostId;
    }

    public DateTime getVerificationDate() {
        return verificationDate;
    }

    public DateTime getVerifiedUntilDate() {
        return verifiedUntilDate;
    }

    public long getVerificationUin() {
        return verificationUin;
    }

    @NotNull
    public VerificationType getVerificationType() {
        return verificationType;
    }
}
