package ru.yandex.webmaster3.core.util;

import com.google.common.primitives.UnsignedLong;

/**
 * @author avhaliullin
 */
public class CHIntHash {
    private static final long seed0 = 0x4CF2D2BAAE6DA887L;
    private static final long seed1 = 0xff51afd7ed558ccdL;
    private static final long seed2 = 0xc4ceb9fe1a85ec53L;

    private static long murMurFinalizer(long k) {
        k ^= k >>> 33;
        k *= seed1;
        k ^= k >>> 33;
        k *= seed2;
        k ^= k >>> 33;
        return k;
    }

    public static long intHash64(long arg) {
        return murMurFinalizer(arg ^ seed0);
    }

    public static UnsignedLong intHash64Unsigned(long arg) {
        return UnsignedLong.fromLongBits(intHash64(arg));
    }
}
