package ru.yandex.webmaster3.core.util;

import com.datastax.driver.core.ConsistencyLevel;
import ru.yandex.webmaster3.core.util.environment.YandexEnvironmentProvider;
import ru.yandex.webmaster3.core.util.environment.YandexEnvironmentType;

/**
 * @author avhaliullin
 */
public class ConsistencyUtil {
    public static ConsistencyLevel quorum() {
        YandexEnvironmentType environmentType = YandexEnvironmentProvider.getEnvironmentType();
        switch (environmentType) {
            case TESTING:
            case DEVELOPMENT:
                return ConsistencyLevel.LOCAL_QUORUM;
            case PRODUCTION:
            default:
                return ConsistencyLevel.QUORUM;
        }
    }
}
