package ru.yandex.webmaster3.core.util;

import org.joda.time.LocalDate;

import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;

/**
 * @author aherman
 */
public class DailyQuotaUtil {
    /**
     * TODO обрабатывать возможные перерасходы
     */
    public static QuotaUsage computeRemainingQuotaAddUrl(LocalDate today, NavigableMap<LocalDate, Integer> quotaUsage, int maxDailyQuota) {
        int usage = quotaUsage.getOrDefault(today, 0);
        return new QuotaUsage(maxDailyQuota, usage, Math.max(maxDailyQuota - usage, 0));
    }

    public static QuotaUsage computeRemainingQuotaDelUrl(LocalDate today, NavigableMap<LocalDate, Integer> quotaUsage, int maxDailyQuota, int maxDaysLookup) {
        LocalDate lookupFromDate = today.minusDays(maxDaysLookup);
        SortedMap<LocalDate, Integer> lastEntries = quotaUsage.subMap(lookupFromDate, today);
        LocalDate checkDate = lookupFromDate;
        int todayQuota = maxDailyQuota;
        while (checkDate.isBefore(today)) {
            int usage = lastEntries.getOrDefault(checkDate, 0);
            int quotaOverdraft = Math.max(usage - todayQuota, 0);
            checkDate = checkDate.plusDays(1);
            todayQuota = Math.max(maxDailyQuota - quotaOverdraft, 0);
        }

        int usage = quotaUsage.getOrDefault(today, 0);
        return new QuotaUsage(todayQuota, usage, Math.max(todayQuota - usage, 0));
    }

    public static final QuotaUsage EMPTY_QUOTA = new QuotaUsage(0, 0, 0);

    public static class QuotaUsage {
        private final int todayQuota;
        private final int quotaUsed;
        private final int quotaRemain;

        public QuotaUsage(int todayQuota, int quotaUsed, int quotaRemain) {
            this.todayQuota = todayQuota;
            this.quotaUsed = quotaUsed;
            this.quotaRemain = quotaRemain;
        }

        public int getTodayQuota() {
            return todayQuota;
        }

        public int getQuotaUsed() {
            return quotaUsed;
        }

        public int getQuotaRemain() {
            return quotaRemain;
        }

        public QuotaUsage use(int used) {
            return new QuotaUsage(todayQuota, quotaUsed + used, quotaRemain - used);
        }
    }
}
