package ru.yandex.webmaster3.core.util;

public class FNVHash {
    private static final long FNV1_64_INIT = 0xcbf29ce484222325L;
    private static final long FNV1_PRIME_64 = 1099511628211L;

    public static long hash64(byte[] data) {
        return hash64(data, data.length);
    }

    public static long hash64(byte[] data, int length) {
        long hash = FNV1_64_INIT;
        for (int i = 0; i < length; i++) {
            hash *= FNV1_PRIME_64;
            hash ^= (data[i] & 0xff);
        }

        return hash;
    }

    public static long hash64(String data) {
        return hash64(data.getBytes());
    }

    public static long hash64Mod(String data, int mod) {
        return Long.remainderUnsigned(hash64(data), mod);
    }
}
