package ru.yandex.webmaster3.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;

/**
 * Created by Oleg Bazdyrev on 18/01/2021.
 */
public class GzipUtils {

    private GzipUtils() {

    }

    public static InputStream unGzip(InputStream inputStream) throws IOException {
        inputStream.mark(2);
        int b1 = inputStream.read();
        int b2 = inputStream.read();
        inputStream.reset();
        if ((b1 & 0xFF | ((b2 << 8) & 0xFF00)) == GZIPInputStream.GZIP_MAGIC) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    public static byte[] compress(byte[] data) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(); GZIPOutputStream gzipOs = new GZIPOutputStream(baos)) {
            gzipOs.write(data);
            gzipOs.finish();
            return baos.toByteArray();
        } catch (IOException e) {
            throw new WebmasterException("GZIP error", new WebmasterErrorResponse.InternalUnknownErrorResponse(GzipUtils.class, "GZIP error"), e);
        }
    }

    public static byte[] decompress(byte[] data) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data); GZIPInputStream gzipIs = new GZIPInputStream(bais)) {
            return gzipIs.readAllBytes();
        } catch (IOException e) {
            throw new WebmasterException("GZIP error", new WebmasterErrorResponse.InternalUnknownErrorResponse(GzipUtils.class, "GZIP error"), e);
        }
    }

}
