package ru.yandex.webmaster3.core.util;

import java.lang.reflect.Method;
import java.util.Optional;

/**
 * Класс, который нужен для удобного "захвата" текущего метода, в котором объект этого класса был создан. Предполагаемое использование:
 * Method thisMethod = ReflectionUtils.getCallerMethod(methodWitness);
 *
 * Все методы этого класса перегружены и "зафиналены" ради того, чтобы idea не предлагала их заоверрайдить при исользовании (просто чуть удобнее писать код с completion'ом)
 *
 * @author avhaliullin
 */
public abstract class JavaMethodWitness {
    public final Optional<Method> getEnclosingMethod() {
        return Optional.ofNullable(getClass().getEnclosingMethod());
    }

    @Override
    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    protected final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public final String toString() {
        return super.toString();
    }

    @Override
    protected final void finalize() throws Throwable {
        super.finalize();
    }
}
