package ru.yandex.webmaster3.core.util;

import java.io.IOException;
import java.util.Arrays;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

/**
 * @author avhaliullin
 */
public class JsonStreamUtils {
    public static boolean skipUntilField(JsonParser jp, String fieldName) throws IOException {
        nextTokenAssertTypeIn(jp, JsonToken.FIELD_NAME, JsonToken.END_OBJECT);

        while (jp.getCurrentToken() == JsonToken.FIELD_NAME && !jp.getCurrentName().equals(fieldName)) {
            // at fieldName
            JsonToken token = jp.nextToken();
            // at {, [ or scalar
            if (!token.isScalarValue()) {
                // at { or [
                jp.skipChildren();
            }
            // now at }, ] or scalar
            jp.nextToken();
            // and now at fieldName or }
        }
        return jp.getCurrentToken() == JsonToken.FIELD_NAME && jp.getCurrentName().equals(fieldName);
    }

    public static JsonToken nextTokenAssertTypeIn(JsonParser jp, JsonToken... allowedTokens) throws IOException {
        JsonToken res = jp.nextToken();
        for (JsonToken allowed : allowedTokens) {
            if (allowed == res) {
                return res;
            }
        }
        throw new JsonParseException("Expected one of " + Arrays.toString(allowedTokens) + ", but found " + res.toString(), jp.getCurrentLocation());
    }
}
