package ru.yandex.webmaster3.core.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.NavigableMap;
import java.util.SortedMap;

/**
 * @author aherman
 */
public class MapUtils {
    private static <K, M extends SortedMap<K, ?>> Comparator<? super K> getComparator(M map) {
        Comparator<? super K> comparator = map.comparator();
        if (comparator != null) {
            return comparator;
        }
        Comparator<?> order = Comparator.naturalOrder();
        return (Comparator<? super K>) order;
    }

    public static <K, V, M extends SortedMap<K, V>> SortedMap<K, V> headMap(M map, K toKey) {
        try {
            return map.headMap(toKey);
        } catch (IllegalArgumentException e) {
        }

        Comparator<? super K> comparator = getComparator(map);
        K firstKey = map.firstKey();
        K lastKey = map.lastKey();

        if (comparator.compare(toKey, firstKey) <= 0) {
            return Collections.emptySortedMap();
        }
        if (comparator.compare(lastKey, toKey) < 0) {
            return map;
        }
        return map.headMap(toKey);
    }


    public static <K, V, M extends NavigableMap<K, V>> NavigableMap<K, V> headMap(M map, K toKey, boolean inclusive) {
        try {
            return map.headMap(toKey, inclusive);
        } catch (IllegalArgumentException e) {
        }

        Comparator<? super K> comparator = getComparator(map);
        K firstKey = map.firstKey();
        K lastKey = map.lastKey();

        int t_f = comparator.compare(toKey, firstKey);
        if (t_f < 0) {
            return Collections.emptyNavigableMap();
        }
        if (!inclusive && t_f == 0) {
            return Collections.emptyNavigableMap();
        }
        int l_t = comparator.compare(lastKey, toKey);
        if (l_t < 0 || (l_t == 0 && inclusive)) {
            return map;
        }
        return map.headMap(toKey, inclusive);

    }

    public static <K, V, M extends SortedMap<K, V>> SortedMap<K, V> tailMap(M map, K fromKey) {
        try {
            return map.tailMap(fromKey);
        } catch (IllegalArgumentException e) {
        }

        Comparator<? super K> comparator = getComparator(map);
        K firstKey = map.firstKey();
        K lastKey = map.lastKey();

        if (comparator.compare(lastKey, fromKey) < 0) {
            return Collections.emptySortedMap();
        }
        if (comparator.compare(fromKey, firstKey) < 0) {
            return map;
        }
        return map.tailMap(fromKey);
    }

    public static <K, V, M extends NavigableMap<K, V>> NavigableMap<K, V> tailMap(M map, K fromKey, boolean inclusive) {
        try {
            return map.tailMap(fromKey, inclusive);
        } catch (IllegalArgumentException e) {
        }

        Comparator<? super K> comparator = getComparator(map);
        K firstKey = map.firstKey();
        K lastKey = map.lastKey();

        int l_f = comparator.compare(lastKey, fromKey);
        if (l_f < 0) {
            return Collections.emptyNavigableMap();
        }
        if (l_f == 0 && !inclusive) {
            return Collections.emptyNavigableMap();
        }

        int f_f = comparator.compare(fromKey, firstKey);
        if (f_f < 0) {
            return map;
        }
        return map.tailMap(fromKey, inclusive);
    }
}
